import UIKit

extension ViewController
{
    func makeTiles ()
    {
        tilesArr = []
        centersArr = []
        
        tileSize = gameView.frame.size.width / CGFloat ( gameMode )
        
        let tileCgSize = CGSize (width: tileSize - 5,
                                 height: tileSize - 5)
        var xCen = tileSize / 2.0
        var yCen = tileSize / 2.0
        var counter = 0
        
        for _ in 0..<gameMode
        {
            for _ in 0..<gameMode
            {
                let tile = MyLabel (frame: CGRect(origin: CGPoint.zero,
                                                  size: tileCgSize))
                
                tile.font = UIFont.systemFont(ofSize: 50,
                                              weight: UIFont.Weight.bold)
                tile.textAlignment = NSTextAlignment.center
                
                let tileCen = CGPoint (x: xCen,
                                       y: yCen)
                
                if ( counter == gameMode * gameMode / 2 )
                {
                    counter = 0
                }
                
                
                tile.isUserInteractionEnabled = true
                tile.internalNum = counter
                tile.text = "\(MyLabel.question)"
                
                tilesArr.append(tile)
                centersArr.append(tileCen)
                
                
                counter += 1
                
                tile.center = tileCen
                xCen += tileSize
                
                tile.backgroundColor = UIColor.darkGray
                gameView.addSubview(tile)
            }
            xCen = tileSize / 2
            yCen += tileSize
        }
    }
}
